import random
import sys

# Define possible skills here
S = ["Break Tackle", "Grab", "Guard", "Juggernaut", "Mighty Blow", "Multiple Block", "Piling On", "Stand Firm", "Strong Arm", "Thick Skull"]
A = ["Catch", "Diving Catch", "Diving Tackle", "Dodge", "Jump Up", "Leap", "Side Step", "Sneaky Git", "Sprint", "Sure Feet"]
P = ["Accurate", "Dump-off", "Hail Mary Pass", "Leader", "Nerves of Steel", "Pass", "Safe Trow"]
G = ["Block", "Dauntless", "Dirty Player", "Fend", "Frenzy", "Kick", "Kick-off Return", "Pass Block", "Pro", "Shadowing", "Strip Ball", "Sure Hands", "Tackle", "Wrestle"]
M = ["Big Hand", "Claw", "Disturbing Presence", "Extra Arms", "Foul Appearance", "Horns", "Prehensile Tail", "Tentacles", "Two Heads", "Very Long Legs"]


	

filepath = 'team.txt'
	
players = []
levels = 12
injuries = 3
maxlevel = 7

levelweight = 0
injuryweight = -1
lv1injuries = False
categoryrolls = True
extradoublechance = 0

seed = random.randint(0, 10000000)
injseed = None
random.seed(a=seed)


		
if len(sys.argv) > 1:
	filepath = sys.argv[1]
	print "Randomizing " + filepath + "."
	
skip = False	
for i in range(1,len(sys.argv)):
	if skip:
		continue
		
	arg = sys.argv[i]
	if(arg == "-S" and len(sys.argv) > i+1):
		print("- Seed set to " + sys.argv[i+1])
		seed = sys.argv[i+1]
	elif(arg == "-L" and len(sys.argv) > i+1):
		print("- Levelups set to " + sys.argv[i+1])
		levels = int(sys.argv[i+1])
	elif(arg == "-I" and len(sys.argv) > i+1):
		print("- Injuries set to " + sys.argv[i+1])
		injuries = int(sys.argv[i+1])
	elif(arg == "-IS" and len(sys.argv) > i+1):
		print("- Injuries come from seed " + sys.argv[i+1])
		injseed = int(sys.argv[i+1])
	elif(arg == "-L1I"):
		print("- Level 1 player injuries allowed")
		lv1injuries = True
	elif(arg == "-C"):
		print("- Skills are rolled from a big pool rather than category being rolled first")
		categoryrolls = False
	elif(arg == "-IW" and len(sys.argv) > i+1):
		print("- Injury level weight set to " + sys.argv[i+1])
		injuryweight = float(sys.argv[i+1])	
	elif(arg == "-LW" and len(sys.argv) > i+1):
		print("- Levelup level weight set to " + sys.argv[i+1])
		levelweight = float(sys.argv[i+1])	
	elif(arg == "-DC" and len(sys.argv) > i+1):
		print("- Chance for normal levelups to be doubles instead set to " + sys.argv[i+1])
		extradoublechance = float(sys.argv[i+1])	


random.seed(a=seed)
if((injseed is None) == True):
	injseed = random.randint(0, 10000000);

print("------------------------------------")


# Define class Player to store players
class Player:
	def __init__(self):
		self.name = ""
		self.skills = []
		self.injuries = []
		self.level = 1
		self.singles = ["G"]
		self.doubles = ["A", "P", "S"]


# File printing function
def PrintTeam(playerlist):
		outfile = filepath.split(".")[0] + "_randomized.txt"
		file2 = open(outfile,"w") 

		for player in playerlist:
			tline = player.name + " (level " + str(player.level) + "): "
			for skill in player.skills:
				tline = tline + skill + ", "
			for injury in player.injuries:
				tline = tline + injury + ", "
				
			if(tline.endswith(", ")):
				tline = tline[:(len(tline)-2)]
			file2.write(tline + "\n")
		file2.close() 


# Skill roll function
def getSkill(categories, existing):	
	cats = []
	
	if(categoryrolls == True):
		x = categories[random.randint(0,len(categories)-1)]
		if x == "S":
			cats = cats + S
		elif x == "A":
			cats = cats + A
		elif x == "P":
			cats = cats + P
		elif x == "G":
			cats = cats + G
		elif x == "M":
			cats = cats + M
	else:
		for x in categories:
			if x == "S":
				cats = cats + S
			elif x == "A":
				cats = cats + A
			elif x == "P":
				cats = cats + P
			elif x == "G":
				cats = cats + G
			elif x == "M":
				cats = cats + M
					
	for x in existing:
		if(x in cats):
			cats.remove(x)
			
	if("Grab" in existing and "Frenzy" in cats):
		cats.remove("Frenzy")
	if("Frenzy" in existing and "Grab" in cats):
		cats.remove("Grab")		
		
	return cats[random.randint(0,len(cats)-1)]

	

# Read team file
with open(filepath) as fp:
	line = fp.readline()
	cnt = 1
	while line:
		
		if line.startswith("#") == False and len(line) > 3:	
			parts = line.strip().split(" - ")
			
			# Get name
			player = Player()
			player.name = parts[0].strip()
			
			# Get skill access
			if len(parts) > 1:
				sparts = parts[1].split();
				player.singles = list(sparts[0])
				if len(sparts) > 1:
					player.doubles = list(sparts[1])
					
			# Get existing skills
			if len(parts) > 2:
				player.skills = parts[2].split(", ")
			
			if len(parts) > 3:
				player.level = int(parts[3])
			
			players.append(player)
		line = fp.readline()
		cnt += 1
		
		
# Randomize skills!
while(levels > 0):
	levels = levels - 1
	
	## Pick player to level based on weighing scheme!
	max = 0
	for player in players:
		if player.level < 7:
			max = max + player.level ** levelweight
	
	roll = random.random() * max
	wlevel = 0
	chosen = players[1]
	for player in players:
		if player.level < 7:
			wlevel = wlevel + player.level ** levelweight
			
		if(roll <= wlevel):
			chosen = player
			break
	
	if (chosen is None):
		chosen = players[0]
		print "Error choosing player for levelup!"
	
	
	d1 = random.randint(1,6)
	d2 = random.randint(1,6)

	skill = None
	explanation = ""
	
	# 6,6 = ST
	if d1 == d2 == 6:
		skill = "+ST"
		explanation = "STRENGTH!"
	# 11 = AG
	elif d1 + d2 == 11:
		skill = "+AG"
		explanation = "AGILITY!"
	# 10 = MA or AV
	elif d1 + d2 == 10:
		explanation = "AV or MA!"
		if random.random() > 0.5:
			skill = "+MA"
		else:
			skill = "+AV"
	# Doubles that aren't 10 or 12 = SPECIAL SKILL
	elif d1 == d2:
		skill = getSkill(chosen.doubles, chosen.skills)
		explanation = "DOUBLES!"
	else:
		if (random.random() < extradoublechance):
			skill = getSkill(chosen.doubles, chosen.skills)
			explanation = "SINGLES CONVERTED TO DOUBLES"
		else:
			skill = getSkill(chosen.singles, chosen.skills)
			explanation = "Singles"
		
	chosen.skills.append(skill)
	chosen.level = chosen.level + 1
	
	print chosen.name + " gets to level " + str(chosen.level) + "! He rolls " + str(d1) + ", " + str(d2) + " (" + explanation + ") and gets " + skill

# Randomize injuries!

in_list = []
random.seed(a=injseed)
	
while(len(in_list) < injuries):
	injury = "Niggling injury"
	d1 = random.randint(1,11)
	if(d1 <= 3):
		injury = "Niggling injury"
	elif(d1 <= 6):
		injury = "-MA"
	elif(d1 <= 9):
		injury = "-AV"
	elif(d1 <= 10): 
		injury = "-AG"
	else:
		injury = "-ST"
	in_list.append(injury)

while(len(in_list) > 0):
	
	## Pick player to level based on weighing scheme!
	max = 0
	for player in players:
		if(lv1injuries == False and player.level == 1):
			continue
		if(	player.level - len(player.injuries) > 0):	
			max = max + (player.level - len(player.injuries)) ** injuryweight


	roll = random.random() * max
	
	wlevel = 0
	chosen = None
	for player in players:
		if(lv1injuries == False and player.level == 1):
			continue
		
		if(	player.level - len(player.injuries) > 0):
			lweight = (player.level - len(player.injuries)) ** injuryweight
		else:
			lweight = 0;
			
		wlevel = wlevel + lweight
		
		if(roll <= wlevel and lweight > 0):
			chosen = player
			break
	
	if (chosen is None):
		chosen = players[0]
		print "Error choosing player for injuries!"
		
	injury = in_list[random.randint(0,len(in_list)-1)]
	in_list.remove(injury)
	chosen.injuries.append(injury)
	print chosen.name + " has been injured! He now suffers from " + injury
	
PrintTeam(players)
	
	
