/*
 * Decompiled with CFR 0.152.
 */
package bullshit;

import bullshit.Item;
import bullshit.Spell;
import com.elmokki.Dom3DB;
import com.elmokki.Generic;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.List;

public class Describer {
    Dom3DB spelldb;
    Dom3DB itemdb;
    List<Spell> spells;
    List<Item> items;

    public Describer(int seed, List<Spell> spells, List<Item> items, Dom3DB spelldb, Dom3DB itemdb, int settings) {
        this.spelldb = spelldb;
        this.itemdb = itemdb;
        this.spells = spells;
        this.items = items;
        if (Generic.containsBitmask(settings, 32)) {
            this.writeChangeLog(seed);
        }
        if (Generic.containsBitmask(settings, 64)) {
            this.writeSpellLists(seed);
        }
        if (Generic.containsBitmask(settings, 128)) {
            this.writeByPath(seed);
        }
    }

    private void writeByPath(int seed) {
        int j;
        String str;
        int level;
        int i;
        FileWriter fstream = null;
        try {
            fstream = new FileWriter("./bullshitspells_" + seed + "_by_path.txt");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        PrintWriter tw = new PrintWriter(fstream);
        tw.println("Bullshit Spells, seed " + seed);
        tw.println("List of spells by path");
        tw.println("----------------------------------------------------");
        tw.println();
        int width = 40;
        if (this.spells.size() > 0) {
            i = 0;
            while (i < 8) {
                tw.println(Generic.capitalize(Generic.integerToPath(i)));
                tw.println("----------------------------");
                tw.println();
                level = 0;
                while (level < 10) {
                    tw.println("Level " + level);
                    tw.println("------------");
                    for (Spell spell : this.spells) {
                        if (spell.level != level || !spell.p1.equals(Generic.integerToShortPath(i))) continue;
                        str = spell.name;
                        j = 0;
                        while (j < width - spell.name.toCharArray().length) {
                            str = String.valueOf(str) + " ";
                            ++j;
                        }
                        str = String.valueOf(str) + spell.p1 + spell.lv1;
                        if (!spell.p2.equals("") && spell.lv2 > 0) {
                            str = String.valueOf(str) + spell.p2 + spell.lv2;
                        }
                        str = String.valueOf(str) + ", " + spell.school + " " + spell.level;
                        tw.println(str);
                    }
                    tw.println();
                    ++level;
                }
                ++i;
            }
        }
        tw.println("Magic items (construction)");
        tw.println("----------------------------");
        tw.println();
        i = 0;
        while (i < 8) {
            tw.println(Generic.capitalize(Generic.integerToPath(i)));
            tw.println("----------------------------");
            tw.println();
            level = 0;
            while (level < 10) {
                tw.println("Level " + level);
                tw.println("------------");
                for (Item item : this.items) {
                    if (item.level != level || !item.p1.equals(Generic.integerToShortPath(i))) continue;
                    str = item.name;
                    j = 0;
                    while (j < width - item.name.toCharArray().length) {
                        str = String.valueOf(str) + " ";
                        ++j;
                    }
                    str = String.valueOf(str) + item.p1 + item.lv1;
                    if (!item.p2.equals("") && item.lv2 > 0) {
                        str = String.valueOf(str) + item.p2 + item.lv2;
                    }
                    str = String.valueOf(str) + ", " + "Construction" + " " + item.level;
                    tw.println(str);
                }
                tw.println();
                level += 2;
            }
            ++i;
        }
        tw.flush();
        tw.close();
    }

    private void writeSpellLists(int seed) {
        FileWriter fstream = null;
        try {
            fstream = new FileWriter("./bullshitspells_" + seed + "_by_school.txt");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        PrintWriter tw = new PrintWriter(fstream);
        tw.println("Bullshit Spells, seed " + seed);
        tw.println("List of spells by school and items");
        tw.println("----------------------------------------------------");
        tw.println();
        int width = 40;
        if (this.spells.size() > 0) {
            int i = 0;
            while (i < 7) {
                String school = Generic.capitalize(Generic.integerToSchool(i));
                tw.println(school);
                tw.println("----------------------------");
                tw.println();
                int level = 0;
                while (level < 10) {
                    tw.println("Level " + level);
                    tw.println("------------");
                    for (Spell s : this.spells) {
                        if (s.level != level || !s.school.equals(school)) continue;
                        String str = s.name;
                        int j = 0;
                        while (j < width - s.name.toCharArray().length) {
                            str = String.valueOf(str) + " ";
                            ++j;
                        }
                        str = String.valueOf(str) + s.p1 + s.lv1;
                        if (!s.p2.equals("") && s.lv2 > 0) {
                            str = String.valueOf(str) + s.p2 + s.lv2;
                        }
                        tw.println(str);
                    }
                    tw.println();
                    ++level;
                }
                ++i;
            }
        }
        tw.println("Magic items (construction)");
        tw.println("----------------------------");
        tw.println();
        int level = 0;
        while (level < 10) {
            tw.println("Level " + level);
            tw.println("------------");
            for (Item s : this.items) {
                if (s.level != level) continue;
                String str = s.name;
                int j = 0;
                while (j < width - s.name.toCharArray().length) {
                    str = String.valueOf(str) + " ";
                    ++j;
                }
                str = String.valueOf(str) + s.p1 + s.lv1;
                if (!s.p2.equals("") && s.lv2 > 0) {
                    str = String.valueOf(str) + s.p2 + s.lv2;
                }
                str = String.valueOf(str) + ", " + "Construction" + " " + s.level;
                tw.println(str);
            }
            tw.println();
            level += 2;
        }
        tw.flush();
        tw.close();
    }

    private void writeChangeLog(int seed) {
        String newpaths;
        String oldpaths;
        FileWriter fstream = null;
        try {
            fstream = new FileWriter("./bullshitspells_" + seed + "_changelog.txt");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        PrintWriter tw = new PrintWriter(fstream);
        tw.println("Bullshit Spells, seed " + seed);
        tw.println("Changelog");
        tw.println("----------------------------------------------------");
        tw.println();
        tw.println("Spells");
        tw.println("----------------------------");
        tw.println();
        for (Spell spell : this.spells) {
            tw.println(spell.name);
            oldpaths = "";
            oldpaths = String.valueOf(oldpaths) + this.spelldb.GetValue(spell.id, "p1") + this.spelldb.GetValue(spell.id, "lv1");
            if (!this.spelldb.GetValue(spell.id, "p2").equals("") && this.spelldb.GetInteger(String.valueOf(spell.id), "lv2") > 0) {
                oldpaths = String.valueOf(oldpaths) + this.spelldb.GetValue(spell.id, "p2") + this.spelldb.GetValue(spell.id, "lv2");
            }
            newpaths = "";
            newpaths = String.valueOf(newpaths) + spell.p1 + spell.lv1;
            if (!spell.p2.equals("") && spell.lv2 > 0) {
                newpaths = String.valueOf(newpaths) + spell.p2 + spell.lv2;
            }
            if (!newpaths.equals(oldpaths)) {
                tw.println("- Paths: " + oldpaths + " -> " + newpaths);
            }
            if (!spell.school.equals(this.spelldb.GetValue(spell.id, "school"))) {
                tw.println("- School: " + this.spelldb.GetValue(spell.id, "school") + " -> " + spell.school);
            }
            if (!String.valueOf(spell.level).equals(this.spelldb.GetValue(spell.id, "research"))) {
                tw.println("- Level: " + this.spelldb.GetValue(spell.id, "research") + " -> " + spell.level);
            }
            if (!String.valueOf(spell.fatigue).equals(this.spelldb.GetValue(spell.id, "fatigue"))) {
                tw.println("- Fatigue: " + this.spelldb.GetValue(spell.id, "fatigue") + " -> " + spell.fatigue);
            }
            tw.println();
        }
        tw.println("Items");
        tw.println("----------------------------");
        tw.println();
        for (Item item : this.items) {
            tw.println(item.name);
            oldpaths = "";
            oldpaths = String.valueOf(oldpaths) + this.itemdb.GetValue(item.id, "p1") + this.itemdb.GetValue(item.id, "lv1");
            if (!this.itemdb.GetValue(item.id, "p2").equals("") && this.itemdb.GetInteger(String.valueOf(item.id), "lv2") > 0) {
                oldpaths = String.valueOf(oldpaths) + this.itemdb.GetValue(item.id, "p2") + this.itemdb.GetValue(item.id, "lv2");
            }
            newpaths = "";
            newpaths = String.valueOf(newpaths) + item.p1 + item.lv1;
            if (!item.p2.equals("") && item.lv2 > 0) {
                newpaths = String.valueOf(newpaths) + item.p2 + item.lv2;
            }
            if (!newpaths.equals(oldpaths)) {
                tw.println("- Paths: " + oldpaths + " -> " + newpaths);
            }
            if (!String.valueOf(item.level).equals(this.itemdb.GetValue(item.id, "con"))) {
                tw.println("- Level: " + this.itemdb.GetValue(item.id, "con") + " -> " + item.level);
            }
            tw.println();
        }
        tw.flush();
        tw.close();
    }
}

