/*
 * Decompiled with CFR 0.152.
 */
package bullshit.gui;

import bullshit.Bullshit;
import com.elmokki.Generic;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.ItemSelectable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;

public class GUI
extends JFrame
implements ActionListener,
ItemListener,
ChangeListener {
    private static final long serialVersionUID = 1L;
    JTextPane textPane = new JTextPane();
    JProgressBar progress = new JProgressBar(0, 100);
    JButton startButton;
    JTabbedPane tabs = new JTabbedPane();
    JTextArea amount = new JTextArea("1");
    JTextArea modname = new JTextArea("Random");
    JTextArea seed = new JTextArea("Random");
    JCheckBox seedRandom = new JCheckBox("Random");
    JCheckBox modNameRandom = new JCheckBox("Random");
    JTextArea seeds = new JTextArea("1337, 715517, 80085");
    JCheckBox advDesc = new JCheckBox("Write advanced descriptions");
    JCheckBox basicDesc = new JCheckBox("Write basic descriptions");
    List<JCheckBox> optionChecks = new ArrayList<JCheckBox>();
    JCheckBox seedcheckbox = new JCheckBox("Use predefined nation seeds (separate by line change and/or comma)");
    JCheckBox descByPath = new JCheckBox("Write list of spells by path");
    JCheckBox descBySchool = new JCheckBox("Write list of spells by school");
    JCheckBox descByLog = new JCheckBox("Write spell changelog");
    JCheckBox bloodspells = new JCheckBox("Do not adjust costs of blood rituals");
    JCheckBox noItems = new JCheckBox("Do not randomize spells");
    JCheckBox noSpells = new JCheckBox("Do not randomize items");
    JCheckBox dontChangeSiteSearchPath = new JCheckBox("Allow changing site search spell paths");
    JCheckBox dontChangeMagicBoostPath = new JCheckBox("Allow changing magic boost spell/item paths");
    JCheckBox hideVanillaNations = new JCheckBox("Hide vanilla nations");
    JSlider eraSlider = new JSlider(0, 1, 3, 2);
    JCheckBox nationals = new JCheckBox("Enable national spell path/level randomization");
    JCheckBox paths = new JCheckBox("Disable path type randomization");
    JCheckBox pathlevels = new JCheckBox("Disable path level randomization");
    JCheckBox levels = new JCheckBox("Disable research level randomization");
    JCheckBox schools = new JCheckBox("Disable spell school randomization");
    boolean hasRun = false;

    public static void main(String[] args) throws MalformedURLException {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                GUI g = new GUI();
                g.setVisible(true);
            }
        });
    }

    private void initGUI() {
        this.optionChecks.add(this.advDesc);
        this.optionChecks.add(this.basicDesc);
        this.optionChecks.add(this.seedcheckbox);
        this.optionChecks.add(this.hideVanillaNations);
        this.seedRandom.setSelected(true);
        this.modNameRandom.setSelected(true);
        this.seed.setEnabled(false);
        this.modname.setEnabled(false);
        JPanel panel = new JPanel(new BorderLayout(5, 5));
        JPanel options = new JPanel(new GridLayout(2, 2));
        this.tabs.addTab("Main", panel);
        this.startButton = new JButton("Start!");
        this.startButton.addActionListener(this);
        this.seedRandom.addItemListener(this);
        this.modNameRandom.addItemListener(this);
        this.advDesc.addItemListener(this);
        this.basicDesc.addItemListener(this);
        this.startButton.setPreferredSize(new Dimension(100, 50));
        this.textPane.setPreferredSize(new Dimension(600, 300));
        this.textPane.setBorder(BorderFactory.createLineBorder(Color.black));
        JScrollPane sp = new JScrollPane(this.textPane);
        this.progress.setPreferredSize(new Dimension(-1, 22));
        this.progress.setStringPainted(true);
        this.redirectSystemStreams();
        JPanel east = new JPanel(new GridLayout(20, 1));
        JPanel seedpanel = new JPanel(new GridLayout(1, 3));
        seedpanel.add(new JLabel("Seed"));
        this.seed.setBorder(BorderFactory.createMatteBorder(1, 1, 1, 1, Color.black));
        seedpanel.add(this.seed);
        seedpanel.add(this.seedRandom);
        east.add(seedpanel);
        east.add(new JLabel());
        east.add(this.noSpells);
        east.add(this.noItems);
        east.add(new JLabel());
        east.add(this.nationals);
        east.add(this.paths);
        east.add(this.pathlevels);
        east.add(this.schools);
        east.add(this.levels);
        east.add(new JLabel());
        east.add(this.dontChangeMagicBoostPath);
        east.add(this.dontChangeSiteSearchPath);
        east.add(this.bloodspells);
        east.add(new JLabel());
        east.add(this.descByLog);
        east.add(this.descByPath);
        east.add(this.descBySchool);
        east.add(new JLabel());
        east.add(this.startButton);
        panel.setBorder(new EmptyBorder(new Insets(5, 5, 5, 5)));
        panel.add((Component)sp, "West");
        panel.add((Component)east, "Center");
        this.add(this.tabs);
        this.pack();
        this.setDefaultCloseOperation(3);
        this.setLocationRelativeTo(null);
        System.out.println("Bullshit Spells version " + Bullshit.version);
        System.out.println("--------------------------------------------");
    }

    public GUI() {
        this.setTitle("Bullshit Spells GUI");
        this.setPreferredSize(new Dimension(1000, 425));
        this.setResizable(false);
        this.initGUI();
    }

    private void updateTextPane(final String text) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Document doc = GUI.this.textPane.getDocument();
                try {
                    doc.insertString(doc.getLength(), text, null);
                }
                catch (BadLocationException e) {
                    throw new RuntimeException(e);
                }
                GUI.this.textPane.setCaretPosition(doc.getLength() - 1);
            }
        });
    }

    private List<Integer> parseSeeds() {
        String[] parts;
        ArrayList<Integer> l = new ArrayList<Integer>();
        String text = this.seeds.getText();
        String[] stringArray = parts = text.split(",");
        int n = parts.length;
        int n2 = 0;
        while (n2 < n) {
            String[] parts2;
            String str = stringArray[n2];
            String[] stringArray2 = parts2 = str.split("\n");
            int n3 = parts2.length;
            int n4 = 0;
            while (n4 < n3) {
                String str2 = stringArray2[n4];
                if (Generic.isNumeric(str2.trim())) {
                    l.add(Integer.parseInt(str2.trim()));
                }
                ++n4;
            }
            ++n2;
        }
        return l;
    }

    private void redirectSystemStreams() {
        OutputStream out = new OutputStream(){

            @Override
            public void write(int b) throws IOException {
                GUI.this.updateTextPane(String.valueOf((char)b));
            }

            @Override
            public void write(byte[] b, int off, int len) throws IOException {
                GUI.this.updateTextPane(new String(b, off, len));
            }

            @Override
            public void write(byte[] b) throws IOException {
                this.write(b, 0, b.length);
            }
        };
        System.setOut(new PrintStream(out, true));
        System.setErr(new PrintStream(out, true));
    }

    private void process() {
        Thread thread = new Thread(){

            @Override
            public void run() {
                GUI.this.startButton.setEnabled(false);
                Random r = new Random();
                int s = r.nextInt();
                if (!GUI.this.seedRandom.isSelected()) {
                    s = Integer.parseInt(GUI.this.seed.getText());
                }
                int settings = 0;
                if (GUI.this.nationals.isSelected()) {
                    ++settings;
                }
                if (GUI.this.paths.isSelected()) {
                    settings += 2;
                }
                if (GUI.this.pathlevels.isSelected()) {
                    settings += 4;
                }
                if (GUI.this.levels.isSelected()) {
                    settings += 8;
                }
                if (GUI.this.schools.isSelected()) {
                    settings += 16;
                }
                if (GUI.this.descByLog.isSelected()) {
                    settings += 32;
                }
                if (GUI.this.descBySchool.isSelected()) {
                    settings += 64;
                }
                if (GUI.this.descByPath.isSelected()) {
                    settings += 128;
                }
                if (GUI.this.bloodspells.isSelected()) {
                    settings += 256;
                }
                if (GUI.this.noItems.isSelected()) {
                    settings += 512;
                }
                if (GUI.this.noSpells.isSelected()) {
                    settings += 1024;
                }
                if (GUI.this.dontChangeMagicBoostPath.isSelected()) {
                    settings += 2048;
                }
                if (GUI.this.dontChangeSiteSearchPath.isSelected()) {
                    settings += 4096;
                }
                Bullshit bshit = new Bullshit(s, settings);
                GUI.this.startButton.setEnabled(true);
            }
        };
        thread.start();
        this.hasRun = true;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource().equals(this.startButton)) {
            if (this.modname.getText().length() == 0) {
                System.out.println("Please enter a mod name.");
                return;
            }
            if (!this.seedcheckbox.isSelected()) {
                if (!Generic.isNumeric(this.seed.getText()) && !this.seed.getText().equals("Random")) {
                    System.out.println("Please enter a numeric seed.");
                    return;
                }
                if (!Generic.isNumeric(this.amount.getText()) || Integer.parseInt(this.amount.getText()) < 1) {
                    System.out.println("Please enter a numeric nation amount.");
                    return;
                }
            } else if (this.seedcheckbox.isSelected() && this.parseSeeds().size() == 0) {
                System.out.println("Please specify numeric seeds or disable predefined seeds.");
                return;
            }
            this.process();
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        ItemSelectable source = e.getItemSelectable();
        JTextArea target = null;
        if (source == this.modNameRandom) {
            target = this.modname;
        } else if (source == this.seedRandom) {
            target = this.seed;
        }
        if (target != null) {
            if (e.getStateChange() == 2) {
                target.setEnabled(true);
                if (target == this.seed) {
                    Random r = new Random();
                    target.setText(String.valueOf(r.nextInt()));
                }
            } else if (e.getStateChange() == 1) {
                target.setEnabled(false);
                target.setText("Random");
            }
        }
        if (this.optionChecks.contains(source)) {
            double value = 0.0;
            if (e.getStateChange() == 1) {
                value = 1.0;
            }
            if (source == this.seedcheckbox) {
                this.seeds.setEnabled(e.getStateChange() == 1);
                this.seedRandom.setSelected(true);
                this.seedRandom.setEnabled(e.getStateChange() != 1);
                this.amount.setEnabled(e.getStateChange() != 1);
            }
        }
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        Object source = e.getSource();
    }
}

