/*
 * Decompiled with CFR 0.152.
 */
package com.elmokki;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Scanner;

public class Dom3DB {
    private HashMap<String, String> entryMap = new HashMap();
    private String[] definition;

    public int getSize() {
        return this.entryMap.size();
    }

    public void addToMap(String id, HashMap<String, String> attributes) {
        String line = "";
        String[] stringArray = this.definition;
        int n = this.definition.length;
        int n2 = 0;
        while (n2 < n) {
            String attr = stringArray[n2];
            String value = attributes.get(attr);
            if (attr.equals("id") && value == null) {
                value = String.valueOf(id);
            }
            if (value == null) {
                value = "";
            }
            line = String.valueOf(line) + value + ";";
            ++n2;
        }
        this.entryMap.put(id, line);
    }

    public Dom3DB(String filename) throws FileNotFoundException {
        Scanner file = new Scanner(new FileInputStream(String.valueOf(System.getProperty("user.dir")) + "/" + filename));
        this.definition = file.nextLine().split(";");
        while (file.hasNextLine()) {
            String line = file.nextLine();
            if (line.length() <= 0 || line.split(";").length <= 0) continue;
            this.entryMap.put(line.split(";")[0], line);
        }
        file.close();
    }

    public String GetValue(String id, String value) {
        return this.GetValue(id, value, "");
    }

    public String GetValue(int id, String value) {
        return this.GetValue("" + id, value, "");
    }

    public int GetInteger(String id, String value) {
        return this.GetInteger(id, value, 0);
    }

    public int GetInteger(String id, String value, int defaultvalue) {
        int integer = 0;
        try {
            integer = Integer.parseInt(this.GetValue(id, value, String.valueOf(defaultvalue)));
        }
        catch (Exception e) {
            integer = defaultvalue;
        }
        return integer;
    }

    public List<String> getColumn(String name) {
        ArrayList<String> list = new ArrayList<String>();
        int placeOfValue = -1;
        int i = 0;
        while (i < this.definition.length) {
            if (this.definition[i].toLowerCase().equals(name.toLowerCase())) {
                placeOfValue = i;
                break;
            }
            ++i;
        }
        if (placeOfValue == -1) {
            return list;
        }
        for (String line : this.entryMap.values()) {
            list.add(this.getValue(line, placeOfValue));
        }
        return list;
    }

    public String GetValue(String id, String value, String defaultvalue) {
        String line = this.entryMap.get(id);
        if (id.equals("-1") || line == null || line.equals("")) {
            return defaultvalue;
        }
        int placeOfValue = -1;
        int i = 0;
        while (i < this.definition.length) {
            if (this.definition[i].toLowerCase().equals(value.toLowerCase())) {
                placeOfValue = i;
                break;
            }
            ++i;
        }
        if (placeOfValue == -1) {
            return defaultvalue;
        }
        try {
            if (this.getValue(line, placeOfValue).equals("")) {
                return defaultvalue;
            }
        }
        catch (Exception e) {
            System.out.println("Dom3DB error: id " + id + " index " + placeOfValue + " value " + value + ". This happened probably because an attribute that does not exist was requested.");
        }
        return this.getValue(line, placeOfValue);
    }

    private String getValue(String line, int index) {
        int firstindex = 0;
        int lastindex = line.toCharArray().length;
        int passed = 0;
        int at = 0;
        char[] cArray = line.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            if (c == ';' || at == 0) {
                if (passed == index) {
                    firstindex = at;
                }
                if (passed == index + 1) {
                    lastindex = at;
                    break;
                }
                ++passed;
            }
            ++at;
            ++n2;
        }
        return line.substring(firstindex + 1, lastindex);
    }

    public String getDom3DBname(String attrib) {
        String derp = this.GetValue(attrib, "unitname");
        return derp;
    }
}

