/*
 * Decompiled with CFR 0.152.
 */
package com.elmokki;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.ColorConvertOp;
import java.awt.image.LookupOp;
import java.awt.image.RescaleOp;
import java.awt.image.ShortLookupTable;
import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Random;

public class Drawing {
    public static BufferedImage greyscale(BufferedImage image, int units) {
        ColorSpace cs = ColorSpace.getInstance(1003);
        ColorConvertOp op = new ColorConvertOp(cs, null);
        BufferedImage newimage = op.filter(image, null);
        BufferedImage n = new BufferedImage(image.getWidth(), image.getHeight(), 2);
        Graphics g = n.getGraphics();
        g.drawImage(newimage, 0, 0, null);
        int x = 0;
        while (x < image.getWidth()) {
            int y = 0;
            while (y < image.getHeight()) {
                int clr = image.getRGB(x, y);
                int red = (clr & 0xFF0000) >> 16;
                int green = (clr & 0xFF00) >> 8;
                int blue = clr & 0xFF;
                if (red > 247 && blue > 247 && green == 0) {
                    n.setRGB(x, y, clr);
                }
                ++y;
            }
            ++x;
        }
        return Drawing.darken(n, units);
    }

    public static BufferedImage recolor(BufferedImage image, Color c) throws IOException {
        LookupOp colorizeFilter = Drawing.createColorizeOp(c);
        BufferedImage targetImage = colorizeFilter.filter(image, image);
        return targetImage;
    }

    public static BufferedImage removeBlack(BufferedImage image) {
        LookupOp colorizeFilter = Drawing.createRemoveBlackOp();
        BufferedImage targetImage = colorizeFilter.filter(image, image);
        return targetImage;
    }

    public static BufferedImage darken(BufferedImage image, int units) {
        float un = units;
        float[] factors = new float[]{1.0f, 1.0f, 1.0f, 1.0f};
        float[] offsets = new float[]{un, un, un, 0.0f};
        BufferedImage dstImage = null;
        RescaleOp op = new RescaleOp(factors, offsets, null);
        dstImage = op.filter(image, null);
        int x = 0;
        while (x < image.getWidth()) {
            int y = 0;
            while (y < image.getHeight()) {
                int clr = image.getRGB(x, y);
                int red = (clr & 0xFF0000) >> 16;
                int green = (clr & 0xFF00) >> 8;
                int blue = clr & 0xFF;
                if (red > 247 && blue > 247 && green == 0) {
                    dstImage.setRGB(x, y, clr);
                }
                if (red == 0 && blue == 0 && green == 0) {
                    dstImage.setRGB(x, y, Color.BLACK.getRGB());
                }
                ++y;
            }
            ++x;
        }
        return dstImage;
    }

    public static LookupOp createColorizeOp(Color c) {
        short[] alpha = new short[256];
        short[] red = new short[256];
        short[] green = new short[256];
        short[] blue = new short[256];
        short R1 = (short)c.getRed();
        short B1 = (short)c.getBlue();
        short G1 = (short)c.getGreen();
        int i = 0;
        while (i < 256) {
            alpha[i] = i;
            red[i] = (short)((double)i / 255.0 * (double)R1);
            green[i] = (short)((double)i / 255.0 * (double)B1);
            blue[i] = (short)((double)i / 255.0 * (double)G1);
            i = (short)(i + 1);
        }
        short[][] data = new short[][]{red, green, blue, alpha};
        ShortLookupTable lookupTable = new ShortLookupTable(0, data);
        return new LookupOp(lookupTable, null);
    }

    private static short limitRange(int c) {
        if (c > 255) {
            c = 255;
        }
        if (c < 1) {
            c = 1;
        }
        return (short)c;
    }

    private static LookupOp createRemoveBlackOp() {
        short[] alpha = new short[256];
        short[] red = new short[256];
        short[] green = new short[256];
        short[] blue = new short[256];
        int i = 0;
        while (i < 256) {
            alpha[i] = i;
            red[i] = i;
            green[i] = i;
            blue[i] = i;
            if (red[i] < 15) {
                red[i] = 15;
            }
            if (green[i] < 15) {
                green[i] = 15;
            }
            if (blue[i] < 15) {
                blue[i] = 15;
            }
            i = (short)(i + 1);
        }
        short[][] data = new short[][]{red, green, blue, alpha};
        ShortLookupTable lookupTable = new ShortLookupTable(0, data);
        return new LookupOp(lookupTable, null);
    }

    private static short flipEndian(short signedShort) {
        int input = signedShort & 0xFFFF;
        return (short)(input << 8 | (input & 0xFF00) >>> 8);
    }

    public static void writeTGA(BufferedImage image, String output) throws IOException {
        DataOutputStream out = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(new File(output))));
        out.writeByte(0);
        out.writeByte(0);
        out.writeByte(2);
        out.writeShort(Drawing.flipEndian((short)0));
        out.writeShort(Drawing.flipEndian((short)0));
        out.writeByte(0);
        out.writeShort(Drawing.flipEndian((short)0));
        out.writeShort(Drawing.flipEndian((short)0));
        out.writeShort(Drawing.flipEndian((short)image.getWidth()));
        out.writeShort(Drawing.flipEndian((short)image.getHeight()));
        out.writeByte(24);
        out.writeByte(0);
        int y = image.getHeight() - 1;
        while (y >= 0) {
            int x = 0;
            while (x < image.getWidth()) {
                Color c = new Color(image.getRGB(x, y));
                out.writeByte((byte)c.getBlue());
                out.writeByte((byte)c.getGreen());
                out.writeByte((byte)c.getRed());
                ++x;
            }
            --y;
        }
        out.close();
    }

    public static Color getColor(Random random) {
        int red = random.nextInt(255) + 1;
        int blue = random.nextInt(255) + 1;
        int green = random.nextInt(255) + 1;
        while (red + blue + green > 704 || red + blue + green < 96) {
            red = random.nextInt(256);
            blue = random.nextInt(256);
            green = random.nextInt(256);
        }
        return new Color(red, green, blue);
    }
}

