/*
 * Decompiled with CFR 0.152.
 */
package com.elmokki;

import java.util.ArrayList;
import java.util.List;

public class Generic {
    public static String integerToPath(int integer) {
        String[] paths = new String[]{"fire", "air", "water", "earth", "astral", "death", "nature", "blood", "holy"};
        return paths[integer];
    }

    public static String integerToSchool(int integer) {
        String[] paths = new String[]{"conjuration", "alteration", "evocation", "construction", "enchantment", "thaumaturgy", "blood", "divine"};
        return paths[integer];
    }

    public static int stringToSchool(String str) {
        String[] paths = new String[]{"conjuration", "alteration", "evocation", "construction", "enchantment", "thaumaturgy", "blood", "divine"};
        int i = 0;
        while (i < paths.length) {
            if (paths[i].equals(str.toLowerCase())) {
                return i;
            }
            ++i;
        }
        return 0;
    }

    public static int PathToInteger(String path) {
        String[] paths = new String[]{"fire", "air", "water", "earth", "astral", "death", "nature", "blood", "holy"};
        path = path.toLowerCase().trim();
        int i = 0;
        while (i < 9) {
            if (paths[i].equals(path)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static String integerToShortPath(int integer) {
        String[] paths = new String[]{"F", "A", "W", "E", "S", "D", "N", "B", "H"};
        return paths[integer];
    }

    public static int shortPathToInteger(String path) {
        String[] paths = new String[]{"F", "A", "W", "E", "S", "D", "N", "B", "H"};
        path = path.toUpperCase().trim();
        int i = 0;
        while (i < 9) {
            if (paths[i].equals(path)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static int getNextArgument(List<String> args, String arg, int defaultvalue) {
        int integer = defaultvalue;
        if (args.contains(arg) && args.size() > args.indexOf(arg) + 1) {
            integer = Integer.parseInt(args.get(args.indexOf(arg) + 1));
        }
        return integer;
    }

    public static List<String> getListOfPathsInMask(int mask) {
        int[] masks = new int[]{128, 256, 512, 1024, 2048, 4096, 8192, 16384, 32768};
        String[] paths = new String[]{"fire", "air", "water", "earth", "astral", "death", "nature", "blood", "holy"};
        ArrayList<String> list = new ArrayList<String>();
        int i = masks.length - 1;
        while (i >= 0) {
            if (mask >= masks[i]) {
                list.add(paths[i]);
                mask -= masks[i];
            }
            --i;
        }
        return list;
    }

    public static List<String> parseArgs(String str) {
        return Generic.parseArgs(str, "\"");
    }

    public static boolean containsTag(List<String> tags, String tag) {
        for (String str : tags) {
            List<String> args = Generic.parseArgs(str);
            if (!args.get(0).equals(tag)) continue;
            return true;
        }
        return false;
    }

    public static String getTagValue(List<String> tags, String tag) {
        for (String str : tags) {
            List<String> args = Generic.parseArgs(str);
            if (!args.get(0).equals(tag)) continue;
            args.remove(0);
            return Generic.listToString(args);
        }
        return null;
    }

    public static boolean isNumeric(String str) {
        try {
            double d = Double.parseDouble(str);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static String listToString(List<String> list) {
        String result = "";
        for (String str : list) {
            if (result.length() != 0) {
                result = String.valueOf(result) + " ";
            }
            result = String.valueOf(result) + str;
        }
        return result;
    }

    public static boolean containsBitmask(int bitmask, int wanted) {
        return (bitmask & wanted) != 0;
    }

    public static int AmountOfVariables(int bitmask) {
        int vars = 0;
        int pos = 1;
        while (bitmask > 0) {
            if (Generic.containsBitmask(bitmask, pos)) {
                ++vars;
                bitmask -= pos;
            }
            pos *= 2;
        }
        return vars;
    }

    public static String plural(String line) {
        String end = "";
        if (line.indexOf(" of ") != -1) {
            end = line.substring(line.indexOf(" of "), line.length());
            line = line.substring(0, line.indexOf(" of "));
        }
        if (line.toLowerCase().endsWith("s") || line.toLowerCase().endsWith("x") || line.toLowerCase().endsWith("sh")) {
            line = String.valueOf(line) + "es";
        } else if (line.toLowerCase().endsWith("y")) {
            line = String.valueOf(line.substring(0, line.length() - 1)) + "ies";
        } else if (line.toLowerCase().endsWith("man") && !line.toLowerCase().endsWith("human")) {
            line = String.valueOf(line.substring(0, line.length() - 3)) + "men";
        } else if (!(line.toLowerCase().endsWith("samurai") || line.toLowerCase().endsWith("vanir") || line.toLowerCase().endsWith(" sheep") || line.toLowerCase().endsWith(" fish"))) {
            line = line.toLowerCase().endsWith("van") ? String.valueOf(line) + "ir" : String.valueOf(line) + "s";
        }
        return String.valueOf(line) + end;
    }

    public static String capitalizeFirst(String s) {
        if (s.length() < 2) {
            return s.toUpperCase();
        }
        String string = "";
        string = String.valueOf(s.substring(0, 1).toUpperCase()) + s.substring(1);
        return string;
    }

    public static String capitalize(String s) {
        if (s.length() < 2) {
            return s.toUpperCase();
        }
        String string = "";
        String[] stringArray = s.split(" ");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String str = stringArray[n2];
            if ((str = str.trim()).length() >= 1) {
                string = str.equals("of") || str.equals("the") ? String.valueOf(string) + " " + str : String.valueOf(string) + " " + str.substring(0, 1).toUpperCase() + str.substring(1);
            }
            ++n2;
        }
        string = string.substring(1);
        return string;
    }

    public static List<String> parseArgs(String str, String separator) {
        ArrayList<String> newlist = new ArrayList<String>();
        str = str.trim();
        str = str.replaceAll("\t", " ");
        while (str.length() > 0) {
            boolean done = false;
            if (str.startsWith(separator)) {
                int i = 1;
                while (i < str.length()) {
                    if (("" + str.charAt(i)).equals(separator)) {
                        newlist.add(str.substring(1, i));
                        str = str.substring(i + 1);
                        done = true;
                        break;
                    }
                    ++i;
                }
            }
            if (!done) {
                int index = str.indexOf(" ");
                if (index == -1) {
                    index = str.length();
                }
                newlist.add(str.substring(0, index).trim());
                str = str.substring(index);
            }
            str = str.trim();
        }
        return newlist;
    }

    public static int GetHighestPosition(double[] array) {
        double highestvalue = array[0];
        int highest = 0;
        int i = 0;
        while (i < array.length) {
            if (highestvalue < array[i]) {
                highestvalue = array[i];
                highest = i;
            }
            ++i;
        }
        return highest;
    }

    public static int GetHighestPosition(int[] array) {
        int highestvalue = array[0];
        int highest = 0;
        int i = 0;
        while (i < array.length) {
            if (highestvalue < array[i]) {
                highestvalue = array[i];
                highest = i;
            }
            ++i;
        }
        return highest;
    }
}

